# MailMirror – Lokales IMAP‑Backup mit systemd‑Automatisierung

## Einleitung
MailMirror ist ein leichtgewichtiges Werkzeug zum **lokalen Spiegeln von IMAP‑Postfächern**. Es zerlegt Punkt‑Notation automatisch in Unterordner und speichert jede Nachricht strukturiert nach Jahr, Monat und Datum mit bereinigtem Betreff. Jede Mail erhält HTML‑Ansicht, Rohdatei, Anhänge und Metadaten. Mit systemd lässt sich der Prozess zuverlässig automatisieren.

## Funktionen
- Holt alle IMAP‑Ordner und Unterordner
- Interpretiert Punkt‑Notation als echte Unterordner (z. B. Archiv/Internet/Hosting)
- Ordnernamen: `YYYY-MM-DD_Betreff` unter `Jahr/Monat`
- Speichert: `mail.html`, `raw.eml`, Anhänge, `meta.json`
- Text‑Log und JSON‑Log für Admin‑Panels

## Struktur

/opt/mailmirror/ 
├── config.env 
├── mirror_mail.sh 
├── fetch_mail.py 
├── utils/ 
│ ├── helpers.py 
│ └── logger.py └── README.md



## Installation
```bash
sudo mkdir -p /opt/mailmirror
# Dateien hierhin kopieren
sudo chmod -R 750 /opt/mailmirror
sudo chown -R root:root /opt/mailmirror

sudo mkdir -p /var/lib/mailmirror/work /var/lib/mailmirror/logs
sudo chown -R root:root /var/lib/mailmirror
sudo chmod -R 750 /var/lib/mailmirror



Konfiguration
Bearbeite /opt/mailmirror/config.env:

IMAP_SERVER=imap.example.com
IMAP_USER=deinuser@example.com
IMAP_PASS=deinpasswort
WORKDIR=/var/lib/mailmirror/work
LOG_DIR=/var/lib/mailmirror/logs
TEXT_LOGFILE=/var/lib/mailmirror/logs/mailmirror.log
JSON_LOGFILE=/var/lib/mailmirror/logs/mailmirror.jsonl
MAIL_ID_SCHEME=DATE_SUBJECT
MAX_SUBJECT_DIRLEN=120



Nutzung
cd /opt/mailmirror
./mirror_mail.sh


Systemd (optional)
Service unter /etc/systemd/system/mailmirror.service:

[Unit]
Description=Mail Mirror (lokal)
After=network-online.target

[Service]
Type=oneshot
WorkingDirectory=/opt/mailmirror
ExecStart=/opt/mailmirror/mirror_mail.sh
User=root
Group=root

[Install]
WantedBy=multi-user.target


Timer unter /etc/systemd/system/mailmirror.timer:
[Unit]
Description=Nightly Mail Mirror

[Timer]
OnCalendar=02:00
Persistent=true

[Install]
WantedBy=timers.target

Aktivieren:
sudo systemctl daemon-reload
sudo systemctl enable --now mailmirror.timer

Ergebnisstruktur
WORKDIR/
└── Archiv/
    └── Internet/
        └── Hosting/
            └── Synology/
                └── 2025/
                    └── 12/
                        └── 2025-12-02_Projektstatus/
                            ├── mail.html
                            ├── raw.eml
                            ├── meta.json
                            └── Anhang.pdf



Hinweise:

- Betreff wird bereinigt und ggf. gekürzt (MAX_SUBJECT_DIRLEN)
- Bei unlesbarem Datum: Fallback auf „0000/00/0000_…“
- Nur lokales Speichern (kein Upload)


---

## systemd units (optional)

### mailmirror.service

```ini
[Unit]
Description=Mail Mirror (lokal)
After=network-online.target

[Service]
Type=oneshot
WorkingDirectory=/opt/mailmirror
ExecStart=/opt/mailmirror/mirror_mail.sh
User=root
Group=root

[Install]
WantedBy=multi-user.target

mailmirror.timer
[Unit]
Description=Nightly Mail Mirror

[Timer]
OnCalendar=02:00
Persistent=true

[Install]
WantedBy=timers.target



