#!/bin/bash
# mirror_mail.sh – Hauptskript für lokalen Mail-Mirror

set -euo pipefail

BASE_DIR="$(cd "$(dirname "$0")" && pwd)"
source "$BASE_DIR/config.env"

mkdir -p "$WORKDIR" "$LOG_DIR"

echo "$(date '+%Y-%m-%d %H:%M:%S') - Starte Mail-Mirror" >> "$TEXT_LOGFILE"

python3 "$BASE_DIR/fetch_mail.py" \
  --server "$IMAP_SERVER" \
  --user "$IMAP_USER" \
  --password "$IMAP_PASS" \
  --workdir "$WORKDIR" \
  --text-log "$TEXT_LOGFILE" \
  --json-log "$JSON_LOGFILE" \
  --id-scheme "$MAIL_ID_SCHEME" \
  --max-subject-len "${MAX_SUBJECT_DIRLEN}"

echo "$(date '+%Y-%m-%d %H:%M:%S') - Mail-Mirror abgeschlossen" >> "$TEXT_LOGFILE"

